% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCSRNet-class.R, R/SCSRNoNet-class.R
\name{bsrdmComp}
\alias{bsrdmComp}
\alias{bsrdmComp,SCSRNet-method}
\alias{bsrdmComp,SCSRNoNet-method}
\title{BSRDataModelComp object accessor}
\usage{
\S4method{bsrdmComp}{SCSRNet}(x)

\S4method{bsrdmComp}{SCSRNoNet}(x)
}
\arguments{
\item{x}{SCSRNoNet object}
}
\value{
bsrdmComp

bsrdmComp object
}
\description{
BSRDataModelComp object accessor

BSRDataModelComp object accessor
}
\examples{
data(example_dataset, package = "SingleCellSignalR")
mat <- log1p(data.matrix(example_dataset[, -1])) / log(2)
rownames(mat) <- example_dataset[[1]]
rme <- rowMeans(mat)
mmat <- mat[rme > 0.05, ]
d <- dist(t(mmat))
h <- hclust(d, method = "ward.D")
clusters <- paste0("pop_", cutree(h, 5))

scsrnn <- SCSRNet(mat,
    normalize = FALSE, method = "log-only", 
    min.count = 1, prop = 0.001,
    log.transformed = TRUE, populations = clusters
)

bsrdmComp(scsrnn)

print("bsrdmComp")
data(example_dataset, package = "SingleCellSignalR")
mat <- log1p(data.matrix(example_dataset[, -1])) / log(2)
rownames(mat) <- example_dataset[[1]]
rme <- rowMeans(mat)
mmat <- mat[rme > 0.05, ]
d <- dist(t(mmat))
h <- hclust(d, method = "ward.D")
pop <- paste0("pop_", cutree(h, 5))
scsrnn <- SCSRNoNet(mat,
    normalize = FALSE, method = "log-only",
    log.transformed = TRUE, populations = pop
)
bsrdmComp(scsrnn)
}
