% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signature_exposure.R
\name{signature_exposure}
\alias{signature_exposure}
\title{Estimates the signature exposure of a mutational catalogue}
\usage{
signature_exposure(mut_cat, P = get(utils::data("cosmicSigs", package =
  "SigsPack")), sig_set = NULL, FUN = decomposeQP, ...)
}
\arguments{
\item{mut_cat}{matrix (f by n) conatining one or several mutational 
catalogues of samples whose signature exposures are to be estimated
f is the amount of features that the profiles are defined on
n is the number of catalogues}

\item{P}{Matrix (f by k) containing the signature profiles of k
signatures whose exposure is to be found
k is the amount of signature profiles that P contains
f is the amount of features that the profiles are defined on
(default: COSMIC signature matrix 96 x 30)}

\item{sig_set}{Numeric vector containing the index of the columns from the
signature matrix (which are the signature profiles) that will be used
reconstruct the mutational catalogue.}

\item{FUN}{Function to estimate the signature exposure. Default: Quadratic 
programming (P has to be of full rank to use this method)}

\item{...}{control parameters that will be passed to FUN}
}
\value{
List of the estimated signature exposure, the reconstructed profile
of the sample, the cosine similarity between the two and the error
}
\description{
Estimates the signature exposure of a mutational catalogue by reconstructing
it from a chosen set of signatures, by default, the used method is quadratic
programming
}
\examples{
data(cosmicSigs)
signature_exposure(create_mut_catalogues(10,500)[['catalogues']])
signature_exposure(create_mut_catalogues(10,500)[['catalogues']], sig_set = c(2,7,16,28,30))
signature_exposure(as.matrix(create_mut_catalogues(10,500)[['catalogues']][,1]))



}
