% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBDRemove.R
\name{IBDRemove}
\alias{IBDRemove}
\title{Obtain the problematic sample list from IBD relatedness.}
\usage{
IBDRemove(seqfile, all = FALSE)
}
\arguments{
\item{seqfile}{SeqSQC object, with IBD results.}

\item{all}{whether to check the IBD for all sample pairs (including
the benchmark samples). The default is FALSE.}
}
\value{
a list of 2 elements: \code{$ibd.pairs} is a data frame
    with 5 columns including sample names(id1, id2), IBD
    coefficients of k0 and k1, and kinship for samples with cryptic
    relatedness. \code{$ibd.remove} is a vector of samples to be
    removed, which are generated by extracting the sample with
    higher missing rate in each problematic sample pair.
}
\description{
Function to extract the related sample pairs from IBD results, and
to generate the sample list for removal from the related pairs
based on sample missing rate.
}
\examples{
load(system.file("extdata", "example.seqfile.Rdata", package="SeqSQC"))
gfile <- system.file("extdata", "example.gds", package="SeqSQC")
seqfile <- SeqSQC(gdsfile = gfile, QCresult = QCresult(seqfile))
seqfile <- IBDCheck(seqfile, remove.samples=NULL, LDprune=TRUE, missing.rate=0.1)
IBDRemove(seqfile)
}
\author{
Qian Liu \email{qliu7@buffalo.edu}
}
