% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fdr_cube.R
\name{plot.fdr_cube}
\alias{plot.fdr_cube}
\title{S3 plot function for FDR assessment result arrays}
\usage{
\method{plot}{fdr_cube}(
  x,
  output = "Rconsole",
  filename = "FDR_report_byrun",
  plot_mscore_levels = c(0.01, 0.001),
  ...
)
}
\arguments{
\item{x}{Array of by-run FDR assessment results as produced e.g. by the
function assess_fdr_byrun() from this package.}

\item{output}{Choose output type. "pdf_csv" creates the output as files in
the working directory, "Rconsole" triggers delivery of the output to the
console enabling further computation and/or custom plotting / output.}

\item{filename}{Basename for output files to be created (if output =
"pdf_csv" has been selected).}

\item{plot_mscore_levels}{Define m-score levels to plot the estimated FDR
results.}

\item{...}{Extra arguments passed on to functions inside this.}
}
\value{
Plots in Rconsole or report files.
}
\description{
This function creates standard plots from result arrays as produced by
e.g. the function assess_fdr_byrun(), visualizig assay, peptide and protein
level FDR for each run at m-score cutoffs 1e-2 and 1e-3. Furthermore, Target
and Decoy ID numbers are visualized.
}
\examples{
{
 data("OpenSWATH_data", package="SWATH2stats")
 data("Study_design", package="SWATH2stats")
 data <- sample_annotation(OpenSWATH_data, Study_design)
 x <- assess_fdr_byrun(data, FFT=0.7, output="Rconsole", plot=FALSE)
 retlist <- plot(x, output="Rconsole", filename="Assess_fdr_byrun_testplot",
                          plot_mscore_levels=0.01)
 }
}
\author{
Moritz Heusel
}
