% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STATegRa_combiningMappings.R
\name{combiningMappings}
\alias{combiningMappings}
\title{combiningMappings, combining several mappings for use in the omicsNPC function}
\usage{
combiningMappings(mappings, reference = NULL, retainAll = FALSE)
}
\arguments{
\item{mappings}{List of annotations.}

\item{reference}{If the annotations are data frame, matrices or bioMap objects, 
the name of the column containing the reference elements}

\item{retainAll}{Logical, if set to TRUE measurements that have no counterparts in other datasets are retained}
}
\value{
A data frame encoding the mapping across several dataset
}
\description{
This function combines several annotation so that measurements across different datasets 
are mapped to the same reference elements (e.g., genes).
The annotations should all be either data frame / matrices, named vectors/lists, or bioMap objects.
See the examples for further details
}
\examples{
#Example 1
#Mapping with data frames
mRNA <- data.frame(gene = rep(c('G1', 'G2', 'G3'), each = 2), probeset = paste('p', 1:6, sep = ''));
methylation <- data.frame(gene = c(rep('G1', 3), rep('G2', 4)),
                                 methy = paste('methy', 1:7, sep = ''));
miRNA <- data.frame(gene = c(rep('G1', 2), rep('G2', 1), rep('G3', 2)),
                               miR = c('miR1', 'miR2', 'miR1', 'miR1', 'miR2'));
mappings <- list(mRNA = mRNA, methylation = methylation, miRNA = miRNA);
combiningMappings(mappings = mappings, retainAll = TRUE)

#Example 2
#Mapping with character vectors
mRNA <- rep(c('G1', 'G2', 'G3'), each = 2);
names(mRNA) = paste('p', 1:6, sep = '');
methylation <- c(rep('G1', 3), rep('G2', 4));
names(methylation) = paste('methy', 1:7, sep = '');
miRNA <- c(rep('G1', 2), rep('G2', 1), rep('G3', 2));
names(miRNA) = c('miR1', 'miR2', 'miR1', 'miR1', 'miR2');
mappings <- list(mRNA = mRNA, methylation = methylation, miRNA = miRNA);
combiningMappings(mappings = mappings, retainAll = TRUE)

}
\references{
Nestoras Karathanasis, Ioannis Tsamardinos and Vincenzo Lagani. omicsNPC: applying the Non-Parametric Combination 
methodology to the integrative analysis of heterogeneous omics data. Submitted to PlosONE.
}
\author{
Vincenzo Lagani
}
