% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy_gradient_aggregated.R
\name{entropy_gradient_aggregated}
\alias{entropy_gradient_aggregated}
\title{The aggregated gradient of entropy and the peak of the gradient}
\usage{
entropy_gradient_aggregated(
  spe_object,
  cell_types_of_interest,
  feature_colname,
  radii
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{cell_types_of_interest}{String Vector. The cell types that the entropy
is computed on.}

\item{feature_colname}{String. The column name of the interested cell types.}

\item{radii}{Numeric Vector. A vector of radii within a circle of a reference
cell where the entropy is computed on.}
}
\value{
A list of the gradient of entropy and the peak
}
\description{
This function first calculates the entropy within circles of
  each reference cell at each radius. Then at each radius, the entropy of all
  circles surrounding each cell are aggregated into one number. The function
  sweeps over the specified radii and calculates the aggregated entropy under
  each radius.
}
\examples{
gradient_pos <- seq(50, 500, 50)
gradient_results <- entropy_gradient_aggregated(SPIAT::defined_image,
cell_types_of_interest = c("Tumour","Immune3"),
feature_colname = "Cell.Type", radii = gradient_pos)
plot(1:10,gradient_results$gradient_df[1, 3:12])
}
