% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composition_of_neighborhoods.R
\name{composition_of_neighborhoods}
\alias{composition_of_neighborhoods}
\title{composition_of_neighborhoods}
\usage{
composition_of_neighborhoods(spe_object, feature_colname)
}
\arguments{
\item{spe_object}{SpatialExperiment that is the output of
\code{\link{identify_neighborhoods}}.}

\item{feature_colname}{String. Column with cell types.}
}
\value{
A data.frame is returned
}
\description{
Returns a data.frame which contains the percentages of cells
  with a specific marker within each neighborhood. and the number of cells in
  the neighborhood.
}
\examples{
neighborhoods <- identify_neighborhoods(image_no_markers,
method = "hierarchical", min_neighborhood_size = 100,
cell_types_of_interest = c("Immune", "Immune1", "Immune2"), radius = 50,
feature_colname = "Cell.Type")
neighborhoods_vis <- composition_of_neighborhoods(neighborhoods,
feature_colname="Cell.Type")
}
