% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HG.R
\name{HG}
\alias{HG}
\title{HGScore}
\usage{
HG(datInput)
}
\arguments{
\item{datInput}{A dataframe with column names: idRun, idPrey, countPrey, 
lenPrey. Each row represent one unique protein captured in one pull-down 
experiment.}
}
\value{
A dataframe consists of pairwise combindation of preys identified in 
the input with HG scores indicating interacting probabilities computed from 
negative log transformed Hypergeometric test P-values.
}
\description{
HGScore
Scoring algorithm based on a hypergeometric distribution error model 
(Hart et al.,2007) with incorporation of NSAF (Zybailov, Boris, et al., 2006)
. This algorithm was first introduced to predict the protein complex network 
of Drosophila melanogaster (Guruharsha, K. G., et al., 2011). This scoring 
algorithm was based on matrix model.
}
\examples{
data(TestDatInput)
datScore <- HG(TestDatInput)
head(datScore)
}
\references{
Guruharsha, K. G., et al. 'A protein complex network of 
Drosophila melanogaster.' Cell 147.3 (2011): 690-703.
\url{https://doi.org/10.1016/j.cell.2011.08.047}

Hart, G. Traver, Insuk Lee, and Edward M. Marcotte. 
'A high-accuracy consensus map of yeast protein complexes reveals modular 
nature of gene essentiality.' BMC bioinformatics 8.1 (2007): 236.
\url{https://doi.org/10.1186/1471-2105-8-236}

Zybailov, Boris, et al. 'Statistical analysis of membrane 
proteome expression changes in Saccharomyces c erevisiae.' Journal of 
proteome research 5.9 (2006): 2339-2347.
\url{https://doi.org/10.1021/pr060161n}
}
\author{
Qingzhou Zhang, \email{zqzneptune@hotmail.com}
}
