\name{tabulate.top.indep.features}

\alias{tabulate.top.indep.features}

\title{Lists the mean z-scores for the independent features}

\description{
	Lists the mean z-scores for independent features in the analyzed regions, calculated 
across the significant dependent features. Gives insight in the expression levels most 
strongly associated with copy number changes.
}

\usage{
tabulate.top.indep.features(input.regions = "all chrs",
							input.region.indep = NULL,
                            method = c("full", "smooth", "window", "overlap"),  
                            adjust.method = "BY", 
                            significance = 1,                           
                            decreasing=TRUE, 
                            z.threshold = c(0, 0), 
                            run.name = "analysis_results")

}

\arguments{

	\item{input.regions}{\code{vector} indicating the dependent regions to be analyzed. Can be defined in four ways:
  	      \code{1) predefined input region: } insert a predefined input region, choices are: 
  	      \dQuote{all chrs}, 
  	      \dQuote{all chrs auto}, 
  	      \dQuote{all arms}, 
  	      \dQuote{all arms auto} 
  	      In the predefined regions \dQuote{all arms} and \dQuote{all arms auto} the arms 13p, 14p, 15p, 21p and 22p 
  	      are left out, because in most studies there are no or few probes in these regions. 
  	      To include them, just make your own vector of arms. 
  	      \code{2) whole chromosome(s): } insert a single chromosome or a list of chromosomes as a 
  	      \code{vector:} 
  	      \code{c(1, 2, 3)}. 
  	      \code{3) chromosome arms: } insert a single chromosome arm  or a list of chromosome arms like 
  	      \code{c("1q", "2p", "2q")}.
  	      \code{4) subregions of a chromosome: } insert a chromosome number followed by the start and end position like 
  	      \code{"chr1:1-1000000"} 
  	      These regions can also be combined, e.g. \code{c("chr1:1-1000000","2q", 3)}.
  	      See \code{\link{integrated.analysis}} for more information.} 
  
  	\item{input.region.indep}{fill in}
  	
	\item{method}{this must be the either one of \dQuote{full}, \dQuote{window}, \dQuote{overlap} or \dQuote{smooth} but the data should generated by the 
         same method in \code{integrated.analysis}.}
	
	\item{adjust.method}{Method used to adjust the P-values for multiple testing, see \link[stats:p.adjust]{p.adjust}.
         Default is "BY" recommended when copy number is used as dependent data. 
         See \link{SIM} for more information about adjusting P-values.}
   
	\item{significance}{threshold used to select the significant dependent
   features. Only the z-scores with these features are used to calculate the mean z-scores 
   across the independent features.}

	\item{decreasing}{fill in}
	
	\item{z.threshold}{fill in}

	\item{run.name}{This must be the same a given to \code{integrated.analysis}} 
}

\details{
	\code{tabulate.top.indep.features} can only be run after \link{integrated.analysis} 
with \code{zscores = TRUE}.

Output is a .txt file containing a table with the mean z-scores of all independent features 
per analyzed region. It includes the \code{ann.indep} columns that were read in the 
\link{assemble.data} function.

Additionally it returns a .txt file containing the significant zscores rich regions.

Depending on the argument "adjust.method", the P-values are first corrected for multiple testing. Next, th
e z-scores are filtered to include only those entries that correspond to significant (P-value < "significa
nce") dependent features to calculate the mean z-scores.  

The dependent table can not be generated for diagonal integrated runs.
}

\value{
	Returns a \code{list} of \code{data.frame}'s for each input region.
Significant P-value rich regions are returned as a data.frame. 
This data.frame can be used as an input for \link{getoverlappingregions}. 
Additionally, the results are stored in a subdirectory of \code{run.name} as txt.
}

\author{Marten Boetzer, Melle Sieswerda, Renee X. de Menezes  \email{R.X.Menezes@lumc.nl}}

\seealso{
\link{SIM}, 
\link{tabulate.pvals}, 
\link{tabulate.top.dep.features}
}



\examples{
#first run example(assemble.data)
#and example(integrated.analysis)
table.indep <- tabulate.top.indep.features(input.regions="8q",
		                                  adjust.method="BY",
										  method="full",
										  significance= 0.05,
										  z.threshold=c(-1, 1),
										  run.name="chr8q")
head(table.indep[["8q"]])										  
}
\keyword{misc}

