% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siamcat_class_constructor.R
\name{siamcat}
\alias{siamcat}
\title{SIAMCAT constructor function}
\usage{
siamcat(..., feat=NULL, label=NULL, meta=NULL,
    phyloseq=NULL, validate=TRUE, verbose=3)
}
\arguments{
\item{...}{additional arguments}

\item{feat}{feature information for SIAMCAT (see details)}

\item{label}{label information for SIAMCAT (see details)}

\item{meta}{(optional) metadata information for SIAMCAT (see details)}

\item{phyloseq}{(optional) a phyloseq object for the creation of an SIAMCAT
object (see details)}

\item{validate}{boolean, should the newly constructed SIAMCAT object be
validated? defaults to TRUE (\strong{we strongly recommend against
setting this parameter to FALSE})}

\item{verbose}{control output: \code{0} for no output at all, \code{1}
for only information about progress and success, \code{2} for normal
level of information and \code{3} for full debug information,
defaults to \code{1}}
}
\value{
A new \link{siamcat-class} object
}
\description{
Function to construct an object of class \link{siamcat-class}
}
\details{
Build siamcat-class objects from their components.

This functions creates a SIAMCAT object (see \link{siamcat-class}).
In order to do so, the function needs \itemize{
\item \code{feat} the feature information for SIAMCAT, should be either a
matrix, a data.frame, or a \link[phyloseq]{otu_table-class}. The columns
should correspond to the different samples (e.g. patients) and the rows the
different features (e.g. taxa). Columns and rows should be named.
\item \code{meta} metadata information for the different samples in the
feature matrix. Metadata is optional for the SIAMCAT workflow. Should be
either a data.frame (with the rownames corresponding to the sample
names of the feature matrix) or an object of class
\link[phyloseq]{sample_data-class}
\item \code{phyloseq} Alternatively to supplying both feat and meta,
SIAMCAT can also work with a phyloseq object containing an otu_table and
other optional slots (like sample_data for meta-variables).}

Notice: do supply \strong{either} the feature information as
matrix/data.frame/otu_table (and optionally metadata) \strong{or} a
phyloseq object, but not both.

The label information for SIAMCAT can take several forms:\itemize{
\item metadata column: if there is metadata (either via meta or as
sample_data in the phyloseq object), the label object can be created
by taking the information in a specific metadata column. In order to
do so, \code{label} should be the name of the column, and \code{case}
should indicate which group(s) should be the positive group(s). A
typical example could look like that:

\code{siamcat <- siamcat(feat=feat.matrix, meta=metadata,
    label='DiseaseState', case='CRC')}

for the construction of a label to predict CRC status (which is encoded
in the column \code{"DiseaseState"} of the metadata). For more control
(e.g. specific labels for plotting or specific control state), the
label can also be created outside of the \code{siamcat} function using
the \link{create.label} function.
\item named vector: the label can also be supplied as named vector which
encodes the label either as characters (e.g. "Healthy" and "Diseased"),
as factor, or numerically (e.g. -1 and 1). The vector must be named
with the names of samples (corresponding to the samples in features).
Also here, the information about the positive group(s) is needed via
the \code{case} parameter. Internally, the vector is given to the
\link{create.label} function.
\item label object: A label object can be created with the
\link{create.label} function or by reading a dedicated label file
with \link{read.label}.
}
}
\examples{
# example with package data
data("feat_crc_zeller", package="SIAMCAT")
data("meta_crc_zeller", package="SIAMCAT")

siamcat <- siamcat(feat=feat.crc.zeller,
    meta=meta.crc.zeller,
    label='Group',
    case='CRC')
}
