% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_samples.r
\encoding{UTF-8}
\name{select.samples}
\alias{select.samples}
\title{Select samples based on metadata}
\usage{
select.samples(siamcat, filter, allowed.set = NULL,
allowed.range = NULL, verbose = 1)
}
\arguments{
\item{siamcat}{an object of class \link{siamcat-class}}

\item{filter}{string, name of the meta variable on which the selection 
should be done}

\item{allowed.set}{a vector of allowed values}

\item{allowed.range}{a range of allowed values}

\item{verbose}{integer, control output: \code{0} for no output at all,
\code{1} for only information about progress and success, \code{2} for
normal level of information and \code{3} for full debug information,
defaults to \code{1}}
}
\value{
an object of class \link{siamcat-class} with labels and metadata 
filtered in order to contain only allowed values
}
\description{
This function select samples based on information given in the
metadata
}
\details{
This functions selects labels and metadata based on a specific
column in the metadata. Provided with a column-name in the metadata and a
range or a set of allowed values, the function will filter the
\link{siamcat-class} object accordingly.
}
\examples{
data(siamcat_example)

# Select all samples that fall into an Age-range between 25 and 80 years
siamcat_selected <- select.samples(siamcat_example,
    filter='Age',
    allowed.range=c(25, 80))

# Select only female samples
siamcat_female <- select.samples(siamcat_example,
    filter='Gender',
    allowed.set=c('F'))
}
\keyword{SIAMCAT}
\keyword{select.samples}
