% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_label.r
\encoding{UTF-8}
\name{read.label}
\alias{read.label}
\title{Read label file}
\usage{
read.label(fn.in.label)
}
\arguments{
\item{fn.in.label}{name of the tsv file containing labels}
}
\value{
label object containing several entries:\itemize{
\item \code{$label} named vector containing the numerical labels from the
file;
\item \code{$info} information about the classes in the label;
\item \code{$type} information about the label type (e.g. \code{BINARY});
}
}
\description{
Read label information from a file
}
\details{
This function reads in a tsv file with labels and converts it
into a label.

First row is expected to be

\code{#BINARY:1=[label for cases];
-1=[label for controls]}.

Second row should contain the sample identifiers as tab-separated list
(consistent with feature and metadata).

Third row is expected to contain the actual class labels (tab-separated):
\code{1} for each case and \code{-1} for each control.

Note: Labels can take other numeric values (but not characters or strings);
importantly, the label for cases has to be greater than the one for controls
}
\examples{
# run with example data
fn.label <- system.file('extdata',
    'label_crc_zeller_msb_mocat_specI.tsv',
    package = 'SIAMCAT')

crc.zeller.label <- read.label(fn.label)
}
