% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siamcat_class_accessors.R
\docType{methods}
\name{meta}
\alias{meta}
\alias{meta,siamcat-method}
\alias{meta,sample_data-method}
\title{Retrieve the metadata from a SIAMCAT object}
\usage{
meta(siamcat)

\S4method{meta}{siamcat}(siamcat)

\S4method{meta}{sample_data}(siamcat)
}
\arguments{
\item{siamcat}{(Required). A \link{siamcat-class} object}
}
\value{
The metadata as \link[phyloseq]{sample_data-class} object
}
\description{
Retrieve the metadata from a SIAMCAT object
}
\details{
This function will retrieve the metadata from a
SIAMCAT object. The metadata is a object of the
\link[phyloseq]{sample_data-class}.
}
\examples{
data(siamcat_example)
temp <- meta(siamcat_example)
head(temp)
}
