% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siamcat_class_accessors.R
\docType{methods}
\name{data_split}
\alias{data_split}
\alias{data_split,siamcat-method}
\title{Retrieve the data split from a SIAMCAT object}
\usage{
data_split(siamcat, verbose=1)

\S4method{data_split}{siamcat}(siamcat, verbose = 1)
}
\arguments{
\item{siamcat}{(Required). An instance of \link{siamcat-class}
containing a data split}

\item{verbose}{integer, if the slot is empty, should a message be printed?
values can be either \code{0} (no output) or \code{1} (print message)}
}
\value{
A list containing the data split information or \code{NULL}
}
\description{
Function to retrieve the data split stored in the
\code{data_split} slot within a SIAMCAT object
}
\details{
The function returns a list containing information about the data
split. See \link{create.data.split} for more details.
}
\examples{
data(siamcat_example)
temp <- data_split(siamcat_example)
names(temp)
}
