% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_confounders.r
\encoding{UTF-8}
\name{check.confounders}
\alias{check.confounders}
\title{Check for potential confounders in the metadata}
\usage{
check.confounders(siamcat, fn.plot, meta.in = NULL,
feature.type='filtered', verbose = 1)
}
\arguments{
\item{siamcat}{an object of class \link{siamcat-class}}

\item{fn.plot}{string, filename for the pdf-plot}

\item{meta.in}{vector, specific metadata variable names to analyze, 
defaults to NULL (all metadata variables will be analyzed)}

\item{feature.type}{string, on which type of features should the function
work? Can be either \code{c()"original", "filtered", or "normalized")}.
Please only change this paramter if you know what you are doing!}

\item{verbose}{integer, control output: \code{0} for no output at all, 
\code{1} for only information about progress and success, \code{2} for 
normal level of information and \code{3} for full debug information, 
defaults to \code{1}}
}
\value{
Does not return anything, but outputs plots to specified pdf file
}
\description{
Checks potential confounders in the metadata and visualize the 
results
}
\details{
This function checks for associations between class labels and 
potential confounders (e.g. Age, Sex, or BMI) that are present in the 
metadata. Statistical testing is performed with Fisher's exact test or 
Wilcoxon test, while associations are visualized either as barplot or 
Q-Q plot, depending on the type of metadata.

Additionally, it evaluates associations among metadata variables using
conditional entropy and associations with the label using generalized 
linear models, producing a correlation heatmap and appropriate
quantitative barplots, respectively.

Please note that the confounder check is currently only available for binary
classification problems!
}
\examples{
# Example data
data(siamcat_example)

# Simple working example
check.confounders(siamcat_example, './conf_plot.pdf')
}
\keyword{SIAMCAT}
\keyword{check.confounders}
