% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_associations.r
\encoding{UTF-8}
\name{check.associations}
\alias{check.associations}
\title{Calculate associations between features and labels}
\usage{
check.associations(siamcat, formula="feat~label", test='wilcoxon', 
alpha=0.05, mult.corr="fdr", log.n0=1e-06, pr.cutoff=1e-06, 
probs.fc=seq(.1, .9, .05), paired=NULL, feature.type='filtered', 
verbose = 1)
}
\arguments{
\item{siamcat}{object of class \link{siamcat-class}}

\item{formula}{string, formula used for testing, see Details for more 
information, defaults to \code{"feat~label"}}

\item{test}{string, statistical test used for the association testing, can
be either \code{'wilcoxon'} or \code{'lm'}, see Details for more 
information, defaults to \code{'wilcoxon'}}

\item{alpha}{float, significance level, defaults to \code{0.05}}

\item{mult.corr}{string, multiple hypothesis correction method, see 
\code{\link[stats]{p.adjust}}, defaults to \code{"fdr"}}

\item{log.n0}{float, pseudo-count to be added before log-transformation of 
the data, defaults to \code{1e-06}. Will be ignored if 
\code{feature.type} is \code{"normalized"}.}

\item{pr.cutoff}{float, cutoff for the prevalence computation, defaults to 
\code{1e-06}}

\item{probs.fc}{numeric vector, quantiles used to calculate the generalized
fold change between groups, see Details for more information,  
defaults to \code{seq(.1, .9, .05)}}

\item{paired}{character, column name of the meta-variable containing 
information for a paired test, defaults to \code{NULL}}

\item{feature.type}{string, on which type of features should the function
work? Can be either \code{c("original", "filtered", or "normalized")}.
Please only change this parameter if you know what you are doing!

If \code{feature.type} is \code{"normalized"}, the normalized abundances
will not be log10-transformed.}

\item{verbose}{integer, control output: \code{0} for no output at all, 
\code{1} for only information about progress and success, \code{2} for 
normal level of information and \code{3} for full debug information, 
defaults to \code{1}}
}
\value{
object of class \link{siamcat-class} with the slot 
\code{associations} filled
}
\description{
This function computes different measures of association 
between features and the label and stores the results in the 
\code{association} slot of the SIAMCAT object
}
\section{Statistical testing}{

The function uses the Wilcoxon test as default statistical test for binary 
classification problems. Alternatively, a simple linear model (as 
implemented in \link[stats]{lm}) can be used as well. For regression 
problems, the function defaults to the linear model.
}

\section{Effect sizes}{

The function calculates several measures for the effect size of the 
assocations between microbial features and the label. For binary 
classification problems, these associations are: \itemize{
\item AUROC (area under the Receiver Operating Characteristics curve) as a 
non-parametric measure of enrichment,
\item the generalized fold change (gFC), a pseudo-fold change which is 
calculated as geometric mean of the differences between quantiles across 
both groups,
\item prevalence shift (difference in prevalence between the two groups).}
For regression problems, the effect sizes are: \itemize{
\item Spearman correlation between the feature and the label.}
}

\section{Confounder-corrected testing}{

To correct for possible confounders while testing for association, the 
function uses linear mixed effect models as implemented in the 
\link{lmerTest} package. To do so, the test formula needs to be adjusted 
to include the confounder. For example, when correcting for the metadata 
information \code{Sex}, the formula would be: 
\code{'feat~label+(1|Sex)'} (see also the example below).

Please note that modifying the formula parameter in this function might
lead to unexpected results!
}

\section{Paired testing}{

For paired testing, e.g. when the same patient has been sampled before and
after an intervention, the `paired` parameter can be supplied to the 
function. This indicated a column in the metadata table that holds the 
information about pairing.
}

\examples{
# Example data
data(siamcat_example)

# Simple example
siamcat_example <- check.associations(siamcat_example)


# Confounder-corrected testing (corrected for Sex)
#
# this is not run during checks
# siamcat_example <- check.associations(siamcat_example, 
#     formula='feat~label+(1|Sex)', test='lm')

# Paired testing
#
# this is not run during checks
# siamcat_paired <- check.associations(siamcat_paired, 
#     paired='Individual_ID')
}
\keyword{SIAMCAT}
\keyword{check.associations}
