% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association_plot.R
\encoding{UTF-8}
\name{association.plot}
\alias{association.plot}
\title{Visualize associations between features and classes}
\usage{
association.plot(siamcat, fn.plot=NULL, color.scheme = "RdYlBu",
sort.by = "fc", max.show = 50, plot.type = "quantile.box",
panels = c("fc", "auroc"), prompt=TRUE, verbose = 1)
}
\arguments{
\item{siamcat}{object of class \link{siamcat-class}}

\item{fn.plot}{string, filename for the pdf-plot. If \code{fn.plot} is
\code{NULL}, the plot will be produced in the active graphics device.}

\item{color.scheme}{valid R color scheme or vector of valid R colors (must
be of the same length as the number of classes), defaults to \code{'RdYlBu'}}

\item{sort.by}{string, sort features by p-value (\code{"p.val"}), by fold
change (\code{"fc"}) or by prevalence shift (\code{"pr.shift"}),
defaults to \code{"fc"}}

\item{max.show}{integer, how many associated features should be shown,
defaults to \code{50}}

\item{plot.type}{string, specify how the abundance should be plotted, must
be one of these: \code{c("bean", "box", "quantile.box", "quantile.rect")},
defaults to \code{"quantile.box"}}

\item{panels}{vector, name of the panels to be plotted next to the
abundances, possible entries are \code{c("fc", "auroc", "prevalence")},
defaults to \code{c("fc", "auroc")}}

\item{prompt}{boolean, turn on/off prompting user input when not plotting
into a pdf-file, defaults to TRUE}

\item{verbose}{integer, control output: \code{0} for no output at all,
\code{1} for only information about progress and success, \code{2} for
normal level of information and \code{3} for full debug information,
defaults to \code{1}}
}
\value{
Does not return anything, but instead produces association plot
}
\description{
This function visualizes different measures of association
between features and the label, computed previously with
the \link{check.associations} function
}
\details{
This function visualizes the results of the computations carried
out in the \link{check.associations} function. It produces a plot of the
top \code{max.show} associated features at a user-specified significance
level \code{alpha}.

For binary classification problems, the plot will show the distribution of
the log10-transformed abundances for both classes, a P-value from the
significance test, and user-selected panels for the effect size (AU-ROC,
prevalence shift, or generalized fold change). For regression problems,
the plot will show the Spearman correlation, the significance, and the
linear model effect size.
}
\examples{
# Example data
data(siamcat_example)

# Simple example
association.plot(siamcat_example, fn.plot = "./assoc_plot.pdf")

# Plot associations as box plot
association.plot(siamcat_example,
    fn.plot = "./assoc_plot_box.pdf",
    plot.type = "box")

# Additionally, sort by p-value instead of by fold change
association.plot(siamcat_example,
    fn.plot = "./assoc_plot_fc.pdf",
    plot.type = "box", sort.by = "p.val")

# Custom colors
association.plot(siamcat_example,
    fn.plot = "./assoc_plot_blue_yellow.pdf",
    plot.type = "box", color.scheme = c("cornflowerblue", "#ffc125"))
}
\keyword{SIAMCAT}
\keyword{association.plot}
