% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-prediction.R
\name{predictTxFeaturesPerStrand}
\alias{predictTxFeaturesPerStrand}
\title{Identification of splice junctions and exons for a given
  chromosome and strand}
\usage{
predictTxFeaturesPerStrand(file_bam, paired_end, which, min_junction_count, psi,
  beta, gamma, min_anchor, include_counts, retain_coverage, junctions_only,
  max_complexity, sample_name, verbose)
}
\arguments{
\item{file_bam}{BAM file with genomic RNA-seq read alignments}

\item{paired_end}{Logical, \code{TRUE} for paired-end data,
\code{FALSE} for single-end data}

\item{which}{\code{GRanges} of genomic regions to be considered for
feature prediction, passed to \code{ScanBamParam}}

\item{min_junction_count}{Minimum fragment count required for a splice
junction to be included. If specified, argument \code{alpha} is ignored.}

\item{psi}{Minimum splice frequency required for a splice junction
to be included}

\item{beta}{Minimum relative coverage required for an internal exon
to be included}

\item{gamma}{Minimum relative coverage required for a terminal exon
to be included}

\item{min_anchor}{Integer specifiying minimum anchor length}

\item{include_counts}{Logical indicating whether counts of
compatible fragments should be included in metadata column
\dQuote{N}}

\item{retain_coverage}{Logical indicating whether coverage for each
exon should be retained as an \code{RleList} in metadata
column \dQuote{coverage}. This allows filtering of features
using more stringent criteria after the initial prediction.}

\item{junctions_only}{Logical indicating whether predictions
should be limited to identification of splice junctions only}

\item{max_complexity}{Maximum allowed complexity. If a locus exceeds
this threshold, it is skipped, resulting in a warning.
Complexity is defined as the maximum number of unique predicted
splice junctions overlapping a given position.
High complexity regions are often due to spurious read alignments
and can slow down processing. To disable this filter, set to \code{NA}.}

\item{sample_name}{Sample name used in messages}

\item{verbose}{If \code{TRUE}, generate messages indicating progress}
}
\value{
\code{GRanges} of predicted features
}
\description{
Identification of splice junctions and exons for a given chromosome
and strand.
}
\author{
Leonard Goldstein
}
\keyword{internal}
