% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-prediction.R
\name{predictJunctions}
\alias{predictJunctions}
\title{Identify splice junctions}
\usage{
predictJunctions(frag_exonic, frag_intron, min_junction_count, psi, min_anchor,
  retain_coverage)
}
\arguments{
\item{frag_exonic}{\code{IRangesList} with exonic regions from alignments}

\item{frag_intron}{\code{IRangesList} with introns implied by spliced
alignments}

\item{min_junction_count}{Minimum fragment count required for a splice
junction to be included. If specified, argument \code{alpha} is ignored.}

\item{psi}{Minimum splice frequency required for a splice junction
to be included}

\item{min_anchor}{Integer specifiying minimum anchor length}

\item{retain_coverage}{Logical indicating whether coverage for each
exon should be retained as an \code{RleList} in metadata
column \dQuote{coverage}. This allows filtering of features
using more stringent criteria after the initial prediction.}
}
\value{
\code{IRanges} of splice junctions with metadata
  columns \dQuote{type} and \dQuote{N}, and optionally
  \dQuote{N_splicesite} for \code{retain_coverage = TRUE}
}
\description{
Identify splice junctions from genomic RNA-seq read alignments.
}
\author{
Leonard Goldstein
}
\keyword{internal}
