% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{getSGVariantCounts}
\alias{getSGVariantCounts}
\title{Representative counts and frequency estimates for
  splice variants}
\usage{
getSGVariantCounts(variants, feature_counts = NULL, sample_info = NULL,
  min_denominator = NA, min_anchor = 1, verbose = FALSE, cores = 1)
}
\arguments{
\item{variants}{\code{SGVariants} object}

\item{feature_counts}{\code{SGFeatureCounts} object}

\item{sample_info}{Data frame with sample information.
Required columns are \dQuote{sample_name}, \dQuote{file_bam},
\dQuote{paired_end}, \dQuote{read_length}, \dQuote{frag_length}
and \dQuote{lib_size}. Library information can be obtained with
function \code{getBamInfo}.}

\item{min_denominator}{Integer specifying minimum denominator when
calculating variant frequencies. The total number of boundary-spanning
reads must be equal to or greater than \code{min_denominator} for at
least one event boundary. Otherwise estimates are set to \code{NA}.
If \code{NA}, all estimates are returned.}

\item{min_anchor}{Integer specifiying minimum anchor length}

\item{verbose}{If \code{TRUE}, generate messages indicating progress}

\item{cores}{Number of cores available for parallel processing}
}
\value{
\code{SGVariantCounts} object
}
\description{
For splice variants, obtain counts of compatible fragments spanning
the start and/or end of each variant.
Counts can be obtained from an \code{SGFeatureCounts} object
or from BAM files. Only one of the two arguments \code{feature_counts}
or \code{sample_info} must be specified. Local estimates of relative
usage are calculated at the start and/or end of each splice variant.
For splice variants with relative usage estimates at both start and end,
these are combined by taking a weighted mean, where weights are
proportional to the total number of reads spanning the respective
boundary.
}
\examples{
sgvc_from_sgfc <- getSGVariantCounts(sgv_pred, sgfc_pred)
path <- system.file("extdata", package = "SGSeq")
si$file_bam <- file.path(path, "bams", si$file_bam)
sgvc_from_bam <- getSGVariantCounts(sgv_pred, sample_info = si)
}
\author{
Leonard Goldstein
}
