% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convertToSGFeatures}
\alias{convertToSGFeatures}
\title{Convert transcript features to splice graph features}
\usage{
convertToSGFeatures(x, coerce = FALSE)
}
\arguments{
\item{x}{\code{TxFeatures} object}

\item{coerce}{Logical indicating whether transcript features
should be coerced to splice graph features without disjoining
exons and omitting splice donor and acceptor sites}
}
\value{
\code{SGFeatures} object
}
\description{
Convert transcript features (predicted from RNA-seq data or
extracted from transcript annotation) to splice graph features.
}
\details{
Splice junctions are unaltered. Exons are disjoined into
non-overlapping exon bins. Adjacent exon bins without a splice site
at the shared boundary are merged.

Entries for splice donor and acceptor sites (positions immediately
upstream and downstream of introns, respectively) are added.

In the returned \code{SGFeatures} object, column \code{type} takes
values \dQuote{J} (splice junction), \dQuote{E} (exon bin),
\dQuote{D} (splice donor) or \dQuote{A} (splice acceptor).
Columns \code{splice5p} and \code{splice3p} indicate mandatory
splices at the 5' and 3' end of exon bins, respectively
(determining whether reads overlapping exon boundaries must be
spliced at the boundary to be considered compatible).
\code{splice5p} (\code{splice3p}) is \code{TRUE} if the first (last)
position of the exon coincides with a splice acceptor (donor)
and it is not adjacent to a neighboring exon bin.

Each feature is assigned a unique feature and gene identifier,
stored in columns \code{featureID} and \code{geneID},
respectively. The latter indicates features that belong to the
same gene, represented by a connected component in the splice graph.
}
\examples{
sgf <- convertToSGFeatures(txf_ann)
}
\author{
Leonard Goldstein
}
