% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{rasterizeGeneExpression}
\alias{rasterizeGeneExpression}
\title{rasterizeGeneExpression}
\usage{
rasterizeGeneExpression(
  input,
  assay_name = NULL,
  resolution = 100,
  square = TRUE,
  fun = "mean",
  n_threads = 1,
  BPPARAM = NULL,
  verbose = FALSE
)
}
\arguments{
\item{input}{\code{SpatialExperiment} or \code{list}: Input data represented as a 
\code{SpatialExperiment} or \code{list} of \code{SpatialExperiment}. 
Each \code{SpatialExperiment} is assumed to have an \code{assay} slot containing feature (genes) x observation (cells)
matrix as \code{dgCmatrix} or \code{matrix} and a \code{spatialCoords} slot containing spatial x,y 
coordinates of observations as matrix array. Further, x,y coordinates are assumed 
to be stored in column 1 and 2 of \code{spatialCoords}.}

\item{assay_name}{\code{character}: Name of the assay slot of the input that 
you want to apply rasterization. If no argument is given, the first assay of the input 
would be rasterized. This argument is useful when you have both raw and normalized 
assays stored in the input, and you want to apply rasterization to the normalized assay. 
If the input is a \code{list}, assay_name is assumed to be present in all elements 
(\code{SpatialExperiment}) of the input.}

\item{resolution}{\code{integer} or \code{double}: Resolution refers to the side 
length of each pixel for square pixels and the distance between opposite edges 
of each pixel for hexagonal pixels. The unit of this parameter is assumed to 
be the same as the unit of spatial coordinates of the input data.}

\item{square}{\code{logical}: If TRUE (default), rasterize into square pixels. If FALSE, 
rasterize into hexagonal pixels.}

\item{fun}{\code{character}: If "mean", pixel value for each pixel 
would be mean of gene expression for all cells within the pixel. If 
"sum", pixel value for each pixel would be sum of gene expression for all 
cells within the pixel.}

\item{n_threads}{\code{integer}: Number of threads for parallelization. Default = 1. 
Inputting this argument when the \code{BPPARAM} argument is missing would set parallel 
exeuction back-end to be \code{BiocParallel::MulticoreParam(workers = n_threads)}. 
We recommend setting this argument to be the number of cores available 
(\code{parallel::detectCores(logical = FALSE)}). If \code{BPPARAM} argument is 
not missing, the \code{BPPARAM} argument would override \code{n_threads} argument.}

\item{BPPARAM}{\code{BiocParallelParam}: Optional additional argument for parallelization. 
This argument is provided for advanced users of \code{BiocParallel} for further 
flexibility for setting up parallel-execution back-end. Default is NULL. If 
provided, this is assumed to be an instance of \code{BiocParallelParam}.}

\item{verbose}{\code{logical}: Whether to display verbose output or warning. Default is FALSE}
}
\value{
If the input was given as \code{SpatialExperiment}, the output is returned 
as a new \code{SpatialExperiment} object with \code{assay} slot containing the 
feature (genes) x observations (pixels) matrix (\code{dgCMatrix} or \code{matrix} 
depending on the input, see documentation for \link{rasterizeMatrix}), \code{spatialCoords} 
slot containing spatial x,y coordinates of pixel centroids, and \code{colData} slot 
containing meta data for pixels (number of cells that were aggregated in each pixel, 
cell IDs of cells that were aggregated in each pixel, pixel type based on the 
\code{square} argument, pixel resolution based on the \code{resolution} argument, 
pixel geometry as \code{sfc_POLYGON}). If the input was provided as \code{list} 
of \code{SpatialExperiment}, the output is returned as a new \code{list} of 
\code{SpatialExperiment} containing information described above for corresponding 
\code{SpatialExperiment}. Further, \code{names(input)} is inherited in the output.
}
\description{
Function to rasterize feature x observation matrix in spatially-resolved 
omics data represented as SpatialExperiment class.

This function assumes that the input is provided as a \code{SpatialExperiment} 
object or a \code{list} of \code{SpatialExperiment} objects.
}
\examples{
library(SpatialExperiment)

data("merfish_mousePOA")

# check assay names for this particular SpatialExperiment object (should be "volnorm")
assayNames(merfish_mousePOA)

# rasterize a single SpatialExperiment object
# make sure to specify the assay_name argument when the input SpatialExperiment 
# object has multiple assay names (assay_name is used here as an example)
out <- rasterizeGeneExpression(merfish_mousePOA, assay_name = "volnorm", fun = "mean")

# rasterize a single SpatialExperiment object with user-defined resolution and hexagonal pixels
out <- rasterizeGeneExpression(merfish_mousePOA, assay_name = "volnorm", resolution = 200, 
square = FALSE, fun = "mean")

# rasterize a list of SpatialExperiment objects (in this case, permutated datasets 
# with 3 different rotations)
spe_list <- permutateByRotation(merfish_mousePOA, n_perm = 3)
out_list <- rasterizeGeneExpression(spe_list, assay_name = "volnorm", resolution = 100, 
square = TRUE, fun = "mean")

}
