% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{permutateByRotation}
\alias{permutateByRotation}
\title{permutateByRotation}
\usage{
permutateByRotation(input, n_perm = 1, verbose = FALSE)
}
\arguments{
\item{input}{\code{SpatialExperiment} or \code{list}: Input data represented as a 
\code{SpatialExperiment} or \code{list} of \code{SpatialExperiment}. 
Each \code{SpatialExperiment} is assumed to have an \code{assay} slot containing feature (genes) x observation (cells)
matrix as \code{dgCmatrix} or \code{matrix} and a \code{spatialCoords} slot containing spatial x,y 
coordinates of observations as matrix array. Further, x,y coordinates are assumed 
to be stored in column 1 and 2 of \code{spatialCoords}, and column names of \code{spatialCoords} 
are assumed to be "x" and "y", respectively.}

\item{n_perm}{\code{integer}: Number of permutations. Default = 1. This number is used to compute the angles at which the input is rotated at.}

\item{verbose}{\code{logical}: Whether to display verbose output or warning. Default is FALSE.}
}
\value{
If the input was given as \code{SpatialExperiment}, the output is returned 
as a \code{list} of \code{n_perm} \code{SpatialExperiment} objects. Each \code{SpatialExperiment} 
object has an updated \code{spatialCoords} slot containing the spatial x,y coordinates 
rotated at a corresponding angle. \code{assay} and \code{colData} slots are inherited.
Further, \code{names()} of the output indicates the angles at which the input 
is rotated at. If the input was given as \code{list} of \code{SpatialExperiment}, 
the output is returned as a new \code{list} of \code{length(input)} * \code{n_perm} 
\code{SpatialExperiment} objects. Each \code{SpatialExperiment} object has an 
updated \code{spatialCoords} slot containing the spatial x,y coordinates rotated 
at a corresponding angle. \code{assay} and \code{colData} slots are inherited.
Further, \code{names()} of the output indicates the dataset names from \code{names(input)} 
and the angles at which the input is rotated at.
}
\description{
Function to permutate a given input SpatialExperiment object(s) 
by rotating the x,y coordinates around the midrange point.

This function assumes that the input is provided as a \code{SpatialExperiment} 
object or a \code{list} of \code{SpatialExperiment} objects.

When the input is a \code{list} of \code{SpatialExperiment} objects, 
all \code{SpatialExperiment} objects will be rotated around a common midrange 
point computed based on combined x,y coordinates.
}
\examples{
data("merfish_mousePOA")

# create a list of 3 permutated datasets rotated at 0 (original), 120, and 240 degrees
# this output can directly be fed into rasterizeGeneExpression or rasterizeCellType 
# functions to rasterize all 3 permutations at once with the same pixel coordinates
spe_list <- permutateByRotation(merfish_mousePOA, n_perm = 3)

# create a list of 5 permutated datasets rotated at 0 (original), 72, 144, 216, 288 degrees
spe_list <- permutateByRotation(merfish_mousePOA, n_perm = 5)

}
