% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Iter_optimal.R, R/MediancalcNorm.R,
%   R/sageTestNew.R
\name{Iter_optimal}
\alias{Iter_optimal}
\alias{MediancalcNorm}
\alias{sageTestNew}
\title{Iteration to find the optimal value
A iteration process to compute the normalization factor to identify
difference expression(DE) of genes between different species}
\usage{
Iter_optimal(scale, orth_gene, hkind, a)

MediancalcNorm(orth_gene, hkind)

sageTestNew(x, y, lengthx, lengthy, n1, n2, scale)
}
\arguments{
\item{scale}{A value for normalization factor.}

\item{orth_gene}{Matrix or data.frame containing read counts and gene
length for each orthologous gene between different species. The first and
third column containing gene length, the second and the fourth column
containing read counts.}

\item{hkind}{A vector shows conserved genes position in orthologous genes.}

\item{a}{P-value cutoff in iteration process to find the optimal
normalization factor.}

\item{x}{The read counts for the first species.}

\item{y}{The read counts for the second species.}

\item{lengthx}{The gene length for the first species.}

\item{lengthy}{The gene length for the second species.}

\item{n1}{The total read counts for the first species.}

\item{n2}{The total read counts for the second species.}
}
\value{
factor Computed normalization factor.

scale Computed Normalization factor.

p_value P-values for each orthologous genes between different
species.
}
\description{
Iteration to find the optimal value
A iteration process to compute the normalization factor to identify
difference expression(DE) of genes between different species

Set the initial value
Using median method to compute the normalization factor to identify
difference expression (DE) of genes between different species

Compute the false discovery rate
Compute the p-value for each orthologous genes between different species
}
\section{Functions}{
\itemize{
\item \code{Iter_optimal}: obtain the optimal normalization value.

\item \code{MediancalcNorm}: get scaling factor for different species.

\item \code{sageTestNew}: obtain the p-value for each orthologous genes between
different species.
}}

\examples{
data(sim_data)
scale <- MediancalcNorm(orth_gene=sim_data, hkind=1:1000)
Iter_optimal(scale=scale, orth_gene=sim_data, hkind=1:1000, a=0.05)
data(sim_data)
MediancalcNorm(orth_gene=sim_data, hkind=1:1000)
data(sim_data)
orth_gene <- sim_data
hkind <- 1:1000
scale <- MediancalcNorm(orth_gene=orth_gene, hkind=hkind)
x <- orth_gene[, 2]
y <- orth_gene[, 4]
lengthx <- orth_gene[, 1]
lengthy <- orth_gene[, 3]
n1 <- sum(x)
n2 <- sum(y)
p_value <- sageTestNew(x, y, lengthx, lengthy, n1, n2, scale)
}
\references{
Brawand D, Soumillon M, Necsulea A, Julien P, Csardi G, Harrigan
P, et al. The evolution of gene expression levels in mammalian organs.
Nature. 2011;478:343-348.
}
