\name{SCANVISlinkvar}
\alias{SCANVISlinkvar}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{maps variants to SCANVISscored junctions}
\description{
This function maps variants to SJs by overlapping the union of gene coordinates that harbor the SJs (optionally, with some gene interval expansion) with variant coordinates
}
\usage{
	SCANVISlinkvar(scn, bed, gen, p = 0)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
	\item{scn}{matrix output by SCANVISscan}
	\item{bed}{matrix with variants in bed format with colnames chr, start, end and with and additional description column (eg. ssSNP for splice site mutations)}
  \item{gen}{gencode object as generated by the function SCANVISannotation}
  \item{p}{expands gene intervals up/downstream by p (default=0, no padding)}
}
%\details{
%Requires IRanges package
%%  ~~ If necessary, more details than the description above ~~
%}
\value{Returns the input scn matrix with an additional column showing variants, if any,  that occur in/near the listed genes. For instances where multiple variants map to a SJ, the variants are | separated (eg. chr7:145562;A>G|chr7:145592;C>G)}
%\references{
%% ~put references to the literature/web site here ~
%}
%\author{Phaedra Agius <pagius@nygenome.org>}

\note{The reference genome used to align RNA-seq reads that generated the initial set of SJs should be the same reference genome used for the variant calls.}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{SCANVISscan, SCANVISannotation, SCANVISvisual}

\examples{
data(SCANVISexamples)
gbm3.scn<-SCANVISscan(sj=gbm3,gen=gen19,Rcut=5)
### Variant format required (these are toy variants)
head(gbm3.vcf) 
gbm3.scnv<-SCANVISlinkvar(gbm3.scn,gbm3.vcf,gen19)
table(gbm3.scnv[,'passedMUT'])
### Expand variant intervals by p
gbm3.scnvp<-SCANVISlinkvar(gbm3.scn,gbm3.vcf,gen19,p=100)
### Observe variant chr6:46820148;Z>AA which was not previously matched to any SJ
table(gbm3.scnvp[,'passedMUT'])
}
