% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotMethods.R
\docType{methods}
\name{sc3_plot_consensus}
\alias{sc3_plot_consensus}
\alias{sc3_plot_consensus.SingleCellExperiment}
\alias{sc3_plot_consensus,}
\alias{sc3_plot_consensus,SingleCellExperiment-method}
\alias{sc3_plot_consensus,SingleCellExperiment-method}
\alias{sc3_plot_consensus}
\title{Plot consensus matrix as a heatmap}
\usage{
sc3_plot_consensus.SingleCellExperiment(object, k, show_pdata)

\S4method{sc3_plot_consensus}{SingleCellExperiment}(object, k,
  show_pdata = NULL)
}
\arguments{
\item{object}{an object of 'SingleCellExperiment' class}

\item{k}{number of clusters}

\item{show_pdata}{a vector of colnames of the pData(object) table. Default is NULL.
If not NULL will add pData annotations to the columns of the output matrix}
}
\description{
The consensus matrix is a NxN 
matrix, where N is the number of cells.
It represents similarity between the cells based 
on the averaging of clustering results from all 
combinations of clustering parameters. Similarity 0 
(blue) means that the two cells are always assigned to different clusters. 
In contrast, similarity 1 (red) means that the two cells are always assigned 
to the same cluster. The consensus matrix is clustered by hierarchical 
clustering and has a diagonal-block structure. Intuitively, the perfect 
clustering is achieved when all diagonal blocks are completely red 
and all off-diagonal elements are completely blue.
}
