% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShinyFunctions.R
\name{get_outl_cells}
\alias{get_outl_cells}
\title{Find cell outliers in each cluster.}
\usage{
get_outl_cells(dataset, labels)
}
\arguments{
\item{dataset}{expression matrix}

\item{labels}{cell labels corresponding to the columns of the expression matrix}
}
\value{
a numeric vector containing the cell labels and 
correspoding outlier scores ordered by the labels
}
\description{
Outlier cells in each cluster are detected using robust distances, calculated 
using the minimum covariance determinant (MCD), namely using 
\code{\link[robustbase]{covMcd}}. The outlier score shows how 
different a cell is from all other cells in the cluster and it is defined as 
the differences between the square root of the robust distance and the square 
root of the 99.99% quantile of the Chi-squared distribution.
}
\examples{
d <- get_outl_cells(yan[1:10,], as.numeric(ann[,1]))
head(d)

}
