% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShinyFunctions.R
\name{get_de_genes}
\alias{get_de_genes}
\title{Find differentially expressed genes}
\usage{
get_de_genes(dataset, labels)
}
\arguments{
\item{dataset}{expression matrix}

\item{labels}{cell labels corresponding to the columns of the expression matrix}
}
\value{
a numeric vector containing the differentially expressed genes and 
correspoding p-values
}
\description{
Differential expression is calculated using the non-parametric Kruskal-Wallis test.
A significant \code{p-value} indicates that gene expression in at least one cluster
stochastically dominates one other cluster. Note that the calculation of 
differential expression after clustering can introduce a bias in the 
distribution of \code{p-value}s, and thus we advise to use the \code{p-value}s 
for ranking the genes only.
}
\examples{
d <- get_de_genes(yan[1:10,], as.numeric(ann[,1]))
head(d)

}
