% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats4trim.R
\name{stats4trim}
\alias{stats4trim}
\title{Minimun read mean quality and maximum percentage loss of reads estimations
for trimming step.}
\usage{
stats4trim(rqcResultSet, qmin, pmax)
}
\arguments{
\item{rqcResultSet}{list of \code{RqcResultSet} objects created by
\code{\link{rqc}} and \code{\link{rqcQA}} functions.}

\item{qmin}{Minimum read mean quality value (bewteen 0 and 41).}

\item{pmax}{Maximum percentage of reads permitted been lost during trimming
step.}
}
\value{
A data frame containg estimated minimum quality and maximum
percentage for each input file.
}
\description{
This function estimates how many reads would be lost if the sequences are
filtered by a minimum read mean quality value. Also this function estimates
what is the minimum read mean quality value for filtering and lose max
percentage defined.
}
\examples{

checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")
stats4trim(rqcResultSet, qmin=20)
stats4trim(rqcResultSet, pmax=10)

}
\author{
Welliton Souza
}
\keyword{qc}
\keyword{trimming}
