% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqcReadQualityCalc.R, R/rqcReadQualityPlot.R
\name{rqcReadQualityCalc}
\alias{rqcReadQualityCalc}
\alias{rqcReadQualityPlot}
\title{Per read quality plot}
\usage{
rqcReadQualityCalc(rqcResultSet)

rqcReadQualityPlot(rqcResultSet)
}
\arguments{
\item{rqcResultSet}{list of \code{RqcResultSet} objects created by
\code{\link{rqc}} and \code{\link{rqcQA}} functions.}
}
\value{
Plot object from \code{\link{ggplot}} function.
}
\description{
Plots the quality of all the files by read.
}
\section{Functions}{
\itemize{
\item \code{rqcReadQualityCalc}: calculates necessary statistics
}}

\examples{

checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")
rqcReadQualityPlot(rqcResultSet)

}
\author{
Welliton Souza
}
\keyword{graphics}
\keyword{qc}
