% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqcCycleQualityCalc.R, R/rqcCycleQualityPlot.R
\name{rqcCycleQualityCalc}
\alias{rqcCycleQualityCalc}
\alias{rqcCycleQualityPlot}
\title{Per cycle quality plot}
\usage{
rqcCycleQualityCalc(rqcResultSet)

rqcCycleQualityPlot(rqcResultSet)
}
\arguments{
\item{rqcResultSet}{list of \code{RqcResultSet} objects created by
\code{\link{rqc}} and \code{\link{rqcQA}} functions.}
}
\value{
Plot object from \code{\link{ggplot}} function.
}
\description{
Creates a graph of per cycle quality.
}
\section{Functions}{
\itemize{
\item \code{rqcCycleQualityCalc}: calculates necessary statistics
}}

\examples{

checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, workers=1)
}, keep="rqcResultSet")
rqcCycleQualityPlot(rqcResultSet)

}
\author{
Welliton Souza
}
\keyword{graphics}
\keyword{qc}
