% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqc.R
\name{rqc}
\alias{rqc}
\title{Main Rqc function}
\usage{
rqc(
  path = ".",
  pattern,
  sample = TRUE,
  n = 1e+06,
  group = NULL,
  top = 10,
  pair = NULL,
  outdir = tempdir(),
  file = "rqc_report",
  openBrowser = TRUE,
  workers = multicoreWorkers()
)
}
\arguments{
\item{path}{directory path that contains input files.}

\item{pattern}{a regex expression that macthes to input file names}

\item{sample}{it reads a random sample from files if this parameter is TRUE.}

\item{n}{number of sequences to read from each input file.  This represents
sample size if 'sample' parameter is TRUE, if not represents the chunk size
to read on each iteration.  By default, it reads a sample of one million
sequences from each input file.}

\item{group}{group name for each input file.}

\item{top}{number of top over-represented reads. Default is 10 reads.}

\item{pair}{combination of files for paired-end reads. By default, all input 
files are treated as single-end. For paired-end, please define a vector of
numbers where two index with the same value represent a pair. Examples, 
single-end \code{c(1,2,3,4)} and paired-end \code{c(1,1,2,2)}.}

\item{outdir}{output directory path.  Is created a temporary directory by
default.}

\item{file}{output file name.}

\item{openBrowser}{if TRUE opens report file on default Internet Browser.}

\item{workers}{Number of parallel workers. Set 1 to serial. Default value
from \code{\link{multicoreWorkers}}.}
}
\value{
A invisible named list of \code{RqcResultSet} objects, each one
represents a file.
}
\description{
Rqc is an optimized tool designed for quality assessment of high-throughput
sequencing data. It performs parallel processing of entire files and
produces an HTML report, which contains a set of high-resolution images that
can be directly used on publications.
}
\examples{

  options(device.ask.default = FALSE)
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  rqc(folder, ".fastq.gz", pair=c(1,1), workers=1, openBrowser=FALSE)

}
\seealso{
\code{\link{rqcQA}}
}
\author{
Welliton Souza
}
\keyword{graphics}
\keyword{qc}
