% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertIdOneToOne.R
\name{convertIdOneToOne}
\alias{convertIdOneToOne}
\title{convertId}
\usage{
convertIdOneToOne(
  x,
  dataset = "hsapiens_gene_ensembl",
  filters = "uniprotswissprot",
  attributes = c(filters, "entrezgene_id"),
  verbose = FALSE
)
}
\arguments{
\item{x}{the Ids need to be converted.}

\item{dataset}{Dataset you want to use.  To see the different datasets available within a biomaRt you can e.g. do:  mart = useMart('ensembl'), followed by listDatasets(mart).}

\item{filters}{Filters (one or more) that should be used in the query.  A possible list of filters can be retrieved using the function listFilters.}

\item{attributes}{Attributes you want to retrieve.  A possible list of attributes can be retrieved using the function listAttributes.}

\item{verbose}{Logical. Indicate report extra information on progress or not.}
}
\value{
A converted ID character with the same order of parameter x.
}
\description{
A function to convert ID based on the biomaRt package.
}
\details{
A function to convert ID based on the biomaRt package..
}
\examples{
x<-c("Q04837","P0C0L4","P0C0L5","O75379","Q13068","A2MYD1")
convertIdOneToOne(x,filters="uniprotswissprot",verbose=TRUE)
}
