% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regenrich_rankScore.R
\name{regenrich_rankScore}
\alias{regenrich_rankScore}
\alias{regenrich_rankScore,RegenrichSet-method}
\title{Regulator scoring and ranking}
\usage{
regenrich_rankScore(object)

\S4method{regenrich_rankScore}{RegenrichSet}(object)
}
\arguments{
\item{object}{a `RegenrichSet` object, to which
\code{\link{regenrich_diffExpr}}, \code{\link{regenrich_network}},
and \code{\link{regenrich_enrich}} functions all have been already applied.}
}
\value{
This function returns a `RegenrichSet` object
with an updated `resScore` slots, which is a `regEnrichScore` (also
`data.frame`) object, and an updated
`paramsIn` slot. In the `regEnrichScore` object there are five columns,
which are 'reg' (regulator), 'negLogPDEA' (-log10(p values of differential
expression analysis)), 'negLogPEnrich' (-log10(p values of enrichment
analysis), 'logFC' (log2 fold changes), and 'score' (RegEnrich ranking
score).
}
\description{
As the fourth step of RegEnrich analysis, regulator ranking
is followed by differential expression analysis (regenrich_diffExpr),
regulator-target network inference (regenrich_network), and
enrichment analysis (regenrich_enrich).
}
\examples{
# library(RegEnrich)
data("Lyme_GSE63085")
data("TFs")

data = log2(Lyme_GSE63085$FPKM + 1)
colData = Lyme_GSE63085$sampleInfo

# Take first 2000 rows for example
data1 = data[seq(2000), ]

design = model.matrix(~0 + patientID + week, data = colData)

# Initializing a 'RegenrichSet' object
object = RegenrichSet(expr = data1,
                      colData = colData,
                      method = 'limma', minMeanExpr = 0,
                      design = design,
                      contrast = c(rep(0, ncol(design) - 1), 1),
                      networkConstruction = 'COEN',
                      enrichTest = 'FET')

\donttest{
# Differential expression analysis
object = regenrich_diffExpr(object)

# Network inference using 'COEN' method
object = regenrich_network(object)

# Enrichment analysis by Fisher's exact test (FET)
object = regenrich_enrich(object)

# Regulators ranking
(object = regenrich_rankScore(object))
}
}
\seealso{
Previous step \code{\link{regenrich_enrich}}.
}
