% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regenrich_network.R
\name{regenrich_network}
\alias{regenrich_network}
\alias{regenrich_network,RegenrichSet-method}
\alias{regenrich_network<-}
\alias{regenrich_network<-,RegenrichSet,TopNetwork-method}
\alias{regenrich_network<-,RegenrichSet,data.frame-method}
\title{Regulator-target network inference step}
\usage{
regenrich_network(object, ...)

\S4method{regenrich_network}{RegenrichSet}(object, ...)

regenrich_network(object) <- value

\S4method{regenrich_network}{RegenrichSet,TopNetwork}(object) <- value

\S4method{regenrich_network}{RegenrichSet,data.frame}(object) <- value
}
\arguments{
\item{object}{a `RegenrichSet` object, to which
\code{\link{regenrich_diffExpr}} function has been already applied.}

\item{...}{arguments for network inference.
After constructing a `RegenrichSet` object using \code{\link{RegenrichSet}}
function, all arguments for RegEnrich analysis have been initialized and
stored in `paramsIn`` slot. The arguments for network inference can be
re-specified here.\cr\cr
These arguments include 'networkConstruction', 'reg', 'rowSample',
'softPower', 'networkType', 'TOMDenom', 'RsquaredCut', 'edgeThreshold',
'K', 'nbTrees', 'importanceMeasure', 'trace',
'BPPARAM', 'minR', 'topNetPercent', and 'directed'.\cr\cr
See \code{\link{RegenrichSet}} function for more details about these
arguments.}

\item{value}{either a `TopNetwork` object or `data.frame` object.
If value is a `data.frame` object, then the number of columns of}
}
\value{
This function returns a `RegenrichSet` object with an updated
`network` and `topNetP` slots, which are `TopNetwork` objects, and
an updated `paramsIn` slot.
See \code{\link{TopNetwork-class}} class for more details.

This function returns a `RegenrichSet` object with an updated
`network` and `topNetP` slots, which are `TopNetwork` objects, and an
updated `paramsIn` slot.
See \code{\link{TopNetwork-class}} class for more details.
}
\description{
As the second step of RegEnrich analysis, network inference
is followed by differential expression analysis (regenrich_diffExpr).

Provide a network to `RegenrichSet` object.
}
\examples{
# library(RegEnrich)
data("Lyme_GSE63085")
data("TFs")

data = log2(Lyme_GSE63085$FPKM + 1)
colData = Lyme_GSE63085$sampleInfo

# Take first 2000 rows for example
data1 = data[seq(2000), ]

design = model.matrix(~0 + patientID + week, data = colData)

# Initializing a 'RegenrichSet' object
object = RegenrichSet(expr = data1,
                      colData = colData,
                      method = 'limma', minMeanExpr = 0,
                      design = design,
                      contrast = c(rep(0, ncol(design) - 1), 1),
                      networkConstruction = 'COEN',
                      enrichTest = 'FET')

\donttest{
# Differential expression analysis
(object = regenrich_diffExpr(object))

# Network inference using 'COEN' method
(object = regenrich_network(object))
}
}
\seealso{
Previous step \code{\link{regenrich_diffExpr}},
and next step \code{\link{regenrich_enrich}}. User defined
network \code{\link{regenrich_network<-}}
}
