% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotSoftPower}
\alias{plotSoftPower}
\title{Plot soft power for WGCNA analysis}
\usage{
plotSoftPower(
  expr,
  rowSample = FALSE,
  weights = NULL,
  powerVector = c(seq(10), seq(12, 20, by = 2)),
  RsquaredCut = 0.85,
  networkType = "unsigned",
  removeFirst = FALSE,
  nBreaks = 10,
  corFnc = WGCNA::cor,
  corOptions = list(use = "p")
)
}
\arguments{
\item{expr}{Gene expression data, either a matrix or a data frame.
By default, each row represents a gene, each column represents a sample.}

\item{rowSample}{logic. If \code{TRUE}, each row represents a sample.
The default is \code{FALSE}.}

\item{weights, }{optional observation weights for \code{expr} to be used 
in correlation calculation.}

\item{powerVector}{a vector of soft thresholding powers for which the scale
free topology fit indices are to be calculated.}

\item{RsquaredCut}{desired minimum scale free topology fitting index R^2.
The default is 0.85.}

\item{networkType}{character, network type. Allowed values are
(unique abbreviations of) "unsigned" (default), "signed", "signed hybrid".
See \code{\link{adjacency}}.}

\item{removeFirst, }{should the first bin be removed from the connectivity 
histogram? The default is FALSE.}

\item{nBreaks, }{number of bins in connectivity histograms. The default is
10.}

\item{corFnc, }{correlation function to be used in adjacency calculation.
The default is the \code{cor} function in WGCNA.}

\item{corOptions, }{a named list of options to the correlation function 
specified in corFnc. The default is list(use = "p").}
}
\value{
a list of three elements: \code{powerEstimate}, \code{fitIndices},
and \code{plot}.
\code{powerEstimate} is an estimate of an appropriate soft-thresholding 
power. \code{fitIndices} is a data frame containing the fit indices for 
scale free topology. The \code{plot} is a ggplot object.
}
\description{
Plot soft power and corresponding scale free topology
fitting index to find a proper soft power for WGCNA analysis.
}
\examples{
data(Lyme_GSE63085)
log2FPKM = log2(Lyme_GSE63085$FPKM + 1)
log2FPKMhi = log2FPKM[rowMeans(log2FPKM) >= 10^-3, , drop = FALSE]
log2FPKMhi = head(log2FPKMhi, 3000) # First 3000 genes for example
\donttest{
softP = plotSoftPower(log2FPKMhi, RsquaredCut = 0.85)
print(softP)
}
}
