% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-FactorisedExperiment.R,
%   R/methods-ModularExperiment.R
\name{loadings,FactorisedExperiment-method}
\alias{loadings,FactorisedExperiment-method}
\alias{loadings<-,FactorisedExperiment-method}
\alias{loadings}
\alias{loadings<-}
\alias{loadings,ModularExperiment-method}
\alias{loadings<-,ModularExperiment-method}
\title{Get and set loadings}
\usage{
\S4method{loadings}{FactorisedExperiment}(
  object,
  scale_loadings = FALSE,
  center_loadings = FALSE,
  abs_loadings = FALSE
)

\S4method{loadings}{FactorisedExperiment}(object) <- value

\S4method{loadings}{ModularExperiment}(
  object,
  scale_loadings = FALSE,
  center_loadings = FALSE,
  abs_loadings = FALSE
)

\S4method{loadings}{ModularExperiment}(object) <- value
}
\arguments{
\item{object}{\link[ReducedExperiment]{ReducedExperiment} object or an
object that inherits from this class.}

\item{scale_loadings}{If \code{TRUE}, loadings will be scaled to have a standard
deviation of 0. If the loadings are a matrix, this operation is performed
column-wise.}

\item{center_loadings}{If \code{TRUE}, loadings will be centered to have a mean
of 0. If the loadings are a matrix, this operation is performed
column-wise.}

\item{abs_loadings}{If \code{TRUE}, the absolute values of the loadings will be
returned.}

\item{value}{New value to replace existing loadings.}
}
\value{
If \code{object} is a \link[ReducedExperiment]{FactorisedExperiment}, the
loadings matrix will be returned, with features as rows and reduced
components as columns. If \code{object} is a
\link[ReducedExperiment]{ModularExperiment}, the loadings
will be returned as a vector, with a value for each feature (usually genes).
}
\description{
Method for getting and setting loadings for a
\link[ReducedExperiment]{ReducedExperiment} object.
}
\details{
When available, the module loadings provide the values of the rotation matrix
(usually generated by \link[stats]{prcomp}) used to calculate the
sample-level module vectors available in the \code{reduced} slot. Normally, these
loadings are calculated for each module separately, so their values are
not comparable across modules.
}
\examples{
# Create ModularExperiment with random data (100 features, 50 samples,
# 10 modules)
me <- ReducedExperiment:::.createRandomisedModularExperiment(100, 50, 10)
me

# Retrieve the loadings
loadings(me)[1:10]

# Change a loading
loadings(me)[9] <- 8
loadings(me)[1:10]

}
\author{
Jack Gisby
}
