% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-FactorisedExperiment.R
\name{getAlignedFeatures}
\alias{getAlignedFeatures}
\alias{getAlignedFeatures,FactorisedExperiment-method}
\title{Get feature alignments with factors}
\usage{
\S4method{getAlignedFeatures}{FactorisedExperiment}(
  object,
  loading_threshold = 0.5,
  proportional_threshold = 0.01,
  feature_id_col = "rownames",
  format = "list",
  center_loadings = FALSE
)
}
\arguments{
\item{object}{A \link[ReducedExperiment]{FactorisedExperiment} object.}

\item{loading_threshold}{A value between 0 and 1 indicating the proportion of
the maximal loading to be used as a threshold. A value of 0.5 (default) means
that genes will be selected if their factor alignment
(derived from the \code{loadings} slot) exceeds or equals 50\% of the maximally
aligned feature.}

\item{proportional_threshold}{A value between 0 and 1 indicating the maximal
proportion of features to be returned. A value of 0.01 (default) means that a
maximum of 1\% of the input features (usually genes) will be returned for
each factor. These will be the genes in the top percentile with respect to
the \code{loadings}}

\item{feature_id_col}{The column in \code{rowData(object)} that will be used as a
feature ID. Setting this to "rownames" (default) instead uses
\code{rownames(object)}.}

\item{format}{A string specifying the format in which to return the results.
See the \code{value} section below.}

\item{center_loadings}{If \code{TRUE}, loadings will be centered column-wise to
have a mean of 0.}
}
\value{
If the \code{format} argument is "list", then a
list will be returned with an entry for each factor, each containing a vector
of input features. Otherwise, if \code{format} is \code{"data.frame"}, a data.frame is
returned with a row for each gene-factor combination. The \code{format} argument
can also be a function to be applied to the output data.frame before
returning the results.
}
\description{
Retrieves features (usually genes) and their alignment (\code{loadings}) with the
factors. Allows for the selection of features whose alignments are high
relative to other features. Useful for functional interpretation of factors.
}
\examples{
# Get a random matrix with rnorm, with 100 rows (features)
# and 20 columns (observations)
X <- ReducedExperiment:::.makeRandomData(100, 20, "feature", "obs")

# Estimate 5 factors based on the data matrix
fe <- estimateFactors(X, nc = 5)

# Get the genes highly aligned with each factor as a list
aligned_features <- getAlignedFeatures(fe, proportional_threshold = 0.03)
aligned_features

# Can also view as a data.frame
head(getAlignedFeatures(fe, format = "data.frame", proportional_threshold = 0.03))

}
\seealso{
\code{\link[=getCommonFeatures]{getCommonFeatures()}}
}
\author{
Jack Gisby
}
