% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedNestMethods.R
\docType{methods}
\name{nestNodes,character-method}
\alias{nestNodes,character-method}
\alias{nestNodes}
\title{nestNodes}
\usage{
\S4method{nestNodes}{character}(
  nodes,
  isAssigned = TRUE,
  isAnchored = TRUE,
  gscale = 40,
  gcoord = c(50, 50),
  status = c("plain", "hide", "transparent"),
  theme = c("th0", "th1", "th2", "th3"),
  gatt = list(),
  parent = NULL,
  verbose = TRUE,
  rdp = NA
)
}
\arguments{
\item{nodes}{A vector with node names available in the RedeR app.}

\item{isAssigned}{Logical value, whether to assign the container name to
the nested nodes}

\item{isAnchored}{Logical value, whether to anchor the container in
dynamic layout sessions.}

\item{gscale}{Expansion factor of the nest area related to a parent nest,
or related to the app panel.}

\item{gcoord}{A numeric vector with 'x' and 'y' coordinates for the center
of nest related to the app panel or a parent container. Coordinates
between 0 and 100 are set to visible areas of the app panel.}

\item{status}{Status of the container on the screen: 'plain',
'transparent', or 'hide'.}

\item{theme}{Some pre-defined graph attributes. Options: 'th0', 'th1',
'th2', and 'th3'.}

\item{gatt}{\itemize{
A list with container attributes (see details).
\item{\code{nestShape}}{ A single string.}
\item{\code{nestSize}}{ A single number >=0.}
\item{\code{nestColor}}{ A single color name or hexadecimal code.}
\item{\code{nestLabel}}{ A single string.}
\item{\code{nestLabelSize}}{ A single number >=0.}
\item{\code{nestLabelColor}}{ A single color name or hexadecimal code.}
\item{\code{nestLabelCoords}}{ A numeric vector with two numbers
(e.g. c(x=0, y=0)).}
\item{\code{nestLineType}}{ A single string.}
\item{\code{nestLineWidth}}{ A single number >=0.}
\item{\code{nestLineColor}}{ A single color name or hexadecimal code.}
}}

\item{parent}{Optional argument, a nest ID of a parent nest.
It must be used with 'isAssign=TRUE'.}

\item{verbose}{A logical value specifying to display detailed messages
(when verbose=TRUE) or not (when verbose=FALSE).}

\item{rdp}{A \code{RedPort}-class object used by internal calls (ignore).}
}
\value{
Add/change graph objects.
}
\description{
Nest nodes into containers.
}
\details{
The \code{gatt} argument can be used to pass detailed attributes to
containers, for example, \code{gatt = list(nestLabel="Nest1")}.
\itemize{
\item{Options for \code{nestShape}: "ELLIPSE", "RECTANGLE",
"ROUNDED_RECTANGLE", "TRIANGLE", and "DIAMOND"}
\item{Options for \code{nestLineType}: "SOLID", "DOTTED",
"DASHED", "LONG_DASH".}
\item{When \code{nestLabelCoords = c(x=0, y=0)} then the label will be
centered and placed at the top of the container.}
}
}
\examples{
# Initialize RedeR and igraph
library(RedeR)
library(igraph)

# create a graph from an edge list
el <- matrix(c("n1", "n2", "n3", "n4"), ncol = 2, byrow = TRUE)
g <- graph.edgelist(el)

\donttest{
# Start the RedeR interface
startRedeR()

# Add 'g' to the interface
addGraphToRedeR(g, layout.kamada.kawai(g))

# Nest nodes in the interface
nestNodes(c("n1", "n2"), gcoord = c(30, 30))
nestNodes(c("n3", "n4"), gcoord = c(70, 70))
}

}
\seealso{
\code{\link{addGraphToRedeR}}, \code{\link{getGraphFromRedeR}}.
}
\author{
Sysbiolab.
}
