# ReactomePA: Reactome Pathway Analysis

[![Project Status: Active - The project has reached a stable, usable
state and is being actively
developed.](http://www.repostatus.org/badges/latest/active.svg)](http://www.repostatus.org/#active)
[![codecov](https://codecov.io/gh/GuangchuangYu/ReactomePA/branch/master/graph/badge.svg)](https://codecov.io/gh/GuangchuangYu/ReactomePA/)
[![](https://img.shields.io/badge/release%20version-1.54.0-green.svg)](https://www.bioconductor.org/packages/ReactomePA)
[![](https://img.shields.io/badge/devel%20version-1.53.0-green.svg)](https://github.com/guangchuangyu/ReactomePA)
[![Bioc](http://www.bioconductor.org/shields/years-in-bioc/clusterProfiler.svg)](https://www.bioconductor.org/packages/devel/bioc/html/clusterProfiler.html#since)

[![platform](http://www.bioconductor.org/shields/availability/devel/ReactomePA.svg)](https://www.bioconductor.org/packages/devel/bioc/html/ReactomePA.html#archives)
[![Last-changedate](https://img.shields.io/badge/last%20change-2025--12--07-green.svg)](https://github.com/GuangchuangYu/ReactomePA/commits/master)
[![Build
Status](http://www.bioconductor.org/shields/build/devel/bioc/ReactomePA.svg)](https://bioconductor.org/checkResults/devel/bioc-LATEST/ReactomePA/)
[![Linux/Mac Travis Build
Status](https://img.shields.io/travis/GuangchuangYu/ReactomePA/master.svg?label=Mac%20OSX%20%26%20Linux)](https://travis-ci.org/GuangchuangYu/ReactomePA)
[![AppVeyor Build
Status](https://img.shields.io/appveyor/ci/Guangchuangyu/ReactomePA/master.svg?label=Windows)](https://ci.appveyor.com/project/GuangchuangYu/ReactomePA)

This package provides functions for pathway analysis based on REACTOME
pathway database. It implements enrichment analysis, gene set enrichment
analysis and several functions for visualization. This package is not
affiliated with the Reactome team.

For details, please visit
<https://yulab-smu.top/biomedical-knowledge-mining-book/>.

## :writing_hand: Authors

Guangchuang YU

School of Basic Medical Sciences, Southern Medical University

<https://yulab-smu.top>

[![Twitter](https://img.shields.io/twitter/url/http/shields.io.svg?style=social&logo=twitter)](https://twitter.com/intent/tweet?hashtags=ReactomePA&url=http://pubs.rsc.org/en/Content/ArticleLanding/2016/MB/C5MB00663E#!divAbstract)
[![saythanks](https://img.shields.io/badge/say-thanks-ff69b4.svg)](https://saythanks.io/to/GuangchuangYu)
[![](https://img.shields.io/badge/follow%20me%20on-WeChat-green.svg)](https://guangchuangyu.github.io/blog_images/biobabble.jpg)

------------------------------------------------------------------------

Please cite the following article when using `ReactomePA`:

***G Yu***, QY He<sup>\*</sup>. ReactomePA: an R/Bioconductor package
for reactome pathway analysis and visualization. ***Molecular
BioSystems*** 2016, 12(2):477-479.

[![](https://img.shields.io/badge/doi-10.1039/c5mb00663e-green.svg)](https://doi.org/10.1039/c5mb00663e)

<!--
&#10;r badge_altmetric("4796667", "green")
&#10;
------------------------------------------------------------------------
&#10;
&#10;<img src="https://guangchuangyu.github.io/software/citation_trend/ReactomePA.png" width="890"/>
&#10;
### Download stats
&#10;[![download](http://www.bioconductor.org/shields/downloads/ReactomePA.svg)](https://bioconductor.org/packages/stats/bioc/ReactomePA/)
r badge_bioc_download("ReactomePA", "total", "blue")
r badge_bioc_download("ReactomePA", "month", "blue")
&#10;
<img src="https://guangchuangyu.github.io/software/dlstats/ReactomePA.png" width="890"/>
&#10;-->
