% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_request.R
\name{set_parameters,ReactomeAnalysisRequest-method}
\alias{set_parameters,ReactomeAnalysisRequest-method}
\title{ReactomeAnalysisRequest - set_parameters}
\usage{
\S4method{set_parameters}{ReactomeAnalysisRequest}(request, ...)
}
\arguments{
\item{request}{The \code{\link{ReactomeAnalysisRequest}} to set the parameters for.}

\item{...}{Any name / value pair to set a parameter (see example). For a complete list of
available parameters use \code{\link{get_reactome_methods}}}
}
\value{
The modified \code{\link{ReactomeAnalysisRequest}} object
}
\description{
Sets the analysis parameters for the given \code{\link{ReactomeAnalysisRequest}}. If the
parameter is already set, it is overwritten. Use \code{\link{get_reactome_methods}}
to get a list of all available parameters for each available method.
}
\details{
Both, parameters with the scope "dataset" as well as "analysis" can be set on the analysis
level. In this case, these parameters overwrite the system's default values. If a parameter
with the scope "dataset" is defined again at the dataset level, this value will overwrite
the analysis' scope value for the given dataset.
}
\examples{
library(methods)

# create a request object
request <- ReactomeAnalysisRequest(method = "Camera")

# add a parameter
request <- set_parameters(request, max_missing_values = 0.5, discrete_norm_function = "TMM")
}
