% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_pseudo_bulk_data.R
\name{generate_pseudo_bulk_data}
\alias{generate_pseudo_bulk_data}
\title{generate_pseudo_bulk_data}
\usage{
generate_pseudo_bulk_data(
  object,
  group_by = NULL,
  split_by = "random",
  k_variable = 4
)
}
\arguments{
\item{object}{The Seurat or SingleCellExperiment object to analyse.}

\item{group_by}{entry in metadata table, based on these cluster annotation pseudo bulk is performed}

\item{split_by}{variable -> split by a variable within the metadata; k must be a string
random -> splits based on a random number; k must be a number
Louvain, Louvain_multilevel, SLM, Leiden -> subclusters k must be a list with [resolution, cluster_1, cluster_2]}

\item{k_variable}{variable dependent on the split_by}
}
\value{
returns pseudo bulk generated data
}
\description{
generate_pseudo_bulk_data
}
\examples{

#using SCE object
library("scRNAseq")
SCE_OBJECT <- ZeiselBrainData()
# generating pseudo bulk data using the SCE object above,
# and clustering level level1class from the metadata

# generate pseudo bulk data based on random subsampling
SCE_RESULT_RANDOM <- generate_pseudo_bulk_data(SCE_OBJECT,
                                               group_by = "level1class",
                                               split_by = "random",
                                               k_variable = 5)

# generate pseudo bulk data based on variable within the metadata
SCE_RESULT_VARIABLE <- generate_pseudo_bulk_data(SCE_OBJECT, "level1class","variable","tissue")

}
