% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapterremoval.R
\name{.callbinary}
\alias{.callbinary}
\title{Make system call for binaries}
\usage{
.callbinary(
  bin1,
  args1,
  op = NULL,
  bin2 = NULL,
  args2 = NULL,
  path = NULL,
  lang = NULL
)
}
\arguments{
\item{bin1}{\code{Character}. The binary used for the system call.}

\item{args1}{\code{Character}. The arguments to pass to the binary.}

\item{op}{\code{Character}. Optional: Generally used if needed to pipe to another binary.}

\item{bin2}{\code{Character}. Optional: Another binary that can be used in the system call.
Generally the output of the first binary is piped to the this binary.}

\item{args2}{\code{Character} Optional: The arguments to pass to the second binary.}

\item{path}{\code{Character} Optional: If passed to function, returns the path.
Needed for Rsamtools to convert from sam to bam.}

\item{lang}{\code{Character}. The interpreter used to execute the binary}
}
\value{
The output of the system call or the path provided.
}
\description{
Function that makes a system call for the bowtie binaries. 
Note it is not intended to be used outside of the package.
}
\author{
Zheng Wei
}
