% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data.R
\name{read_chunk}
\alias{read_chunk}
\title{Read a single Zarr chunk}
\usage{
read_chunk(
  chunk_path,
  metadata,
  s3_client = NULL,
  alt_chunk_dim = NULL,
  fill = FALSE
)
}
\arguments{
\item{chunk_path}{A character vector of length 1, giving the path to the
chunk to be read.}

\item{metadata}{List produced by \code{.read_array_metadata()} holding the contents
of the \code{.zarray} file. If missing this function will be called
automatically, but it is probably preferable to pass the meta data rather
than read it repeatedly for every chunk.}

\item{s3_client}{Object created by \code{\link[paws.storage:s3]{paws.storage::s3()}}. Only required for a
file on S3. Leave as \code{NULL} for a file on local storage.}

\item{alt_chunk_dim}{The dimensions of the array that should be created from
this chunk.  Normally this will be the same as the chunk shape in
\code{metadata}, but when dealing with edge chunks, which may overlap the true
extent of the array the returned array should be smaller than the chunk
shape.}

\item{fill}{Logical of length 1.  If \code{TRUE}, missing chunks will be filled
with the fill value from the array metadata.  If \code{FALSE} (the default),
missing chunks will return \code{NULL}.}
}
\value{
An array containing the decompressed chunk values.
}
\description{
Read a single Zarr chunk
}
\keyword{internal}
