% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data.R
\name{read_chunk}
\alias{read_chunk}
\title{Read a single Zarr chunk}
\usage{
read_chunk(
  zarr_array_path,
  chunk_name,
  metadata,
  s3_client = NULL,
  alt_chunk_dim = NULL
)
}
\arguments{
\item{zarr_array_path}{A character vector of length 1, giving the path to the
Zarr array}

\item{chunk_name}{The name of the chunk to read.}

\item{metadata}{List produced by \code{.read_array_metadata()} holding the contents
of the \code{.zarray} file. If missing this function will be called
automatically, but it is probably preferable to pass the meta data rather
than read it repeatedly for every chunk.}

\item{s3_client}{Object created by \code{\link[paws.storage:s3]{paws.storage::s3()}}. Only required for a
file on S3. Leave as \code{NULL} for a file on local storage.}

\item{alt_chunk_dim}{The dimensions of the array that should be created from
this chunk.  Normally this will be the same as the chunk shape in
\code{metadata}, but when dealing with edge chunks, which may overlap the true
extent of the array the returned array should be smaller than the chunk
shape.}
}
\value{
A list of length 2.  The entries should be names "chunk_data" and
"warning". The first is an array containing the decompressed chunk values,
the second is an integer indicating whether there were any overflow
warnings generated will reading the chunk into an R datatype.
}
\description{
Read a single Zarr chunk
}
\keyword{internal}
