% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipleFamilyCalculations.R
\name{multipleVariantPValue}
\alias{multipleVariantPValue}
\title{generalization of multipleFamilyPValue to multiple variants}
\usage{
multipleVariantPValue(
  snpMat,
  famInfo,
  sharingProbs,
  minorAllele = NULL,
  filter = NULL,
  alpha = 0
)
}
\arguments{
\item{snpMat}{SnpMatrix}

\item{famInfo}{data frame containing pedigree, member, father, mother,
sex, affected fields for each sequenced subject}

\item{sharingProbs}{vector of sharing probabilites, must be a named vector
with famid's for each probability}

\item{minorAllele}{vector specifying the minor allele of each variant}

\item{filter}{criteria for filtering pvalues}

\item{alpha}{parameter for filter}
}
\value{
list containing p-values and potential p-values for each variant
}
\description{
Computes a p-value for each variant sharing pattern
 across families
}
\details{
For each variant, the families which have all sequenced subjects
 sharing the variant and the families which have some sequenced subjects
 sharing the variant are recorded. These values are passed
 to multipleFamilyPValue
}
