% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tnsPlotCovariates.R
\docType{methods}
\name{tnsPlotCovariates,TNS-method}
\alias{tnsPlotCovariates,TNS-method}
\alias{tnsPlotCovariates}
\title{Plot regulon activity and categorical covariates}
\usage{
\S4method{tnsPlotCovariates}{TNS}(
  tns,
  regs = NULL,
  attribs = NULL,
  fname = "covarplot",
  fpath = ".",
  ylab = "Regulon activity (dES)",
  xlab = "Samples",
  plotpdf = FALSE,
  plotbatch = FALSE,
  panelHeights = c(1, 1),
  width = 5.3,
  height = 4,
  dummyEncode = TRUE,
  divs = NULL
)
}
\arguments{
\item{tns}{A A \linkS4class{TNS} object.}

\item{regs}{An optional string vector specifying regulons to plot.}

\item{attribs}{A character vector of attributes listed in the column 
names of the survivalData. All attributes should be either binary
encoded or categorical variables for plotting. Available attributes
can be checked by running  colnames(tnsGet(tns, "survivalData")).
Alternatively, attributes can be grouped when provided within a list.}

\item{fname}{A string. The name of the file in which the plot will be saved}

\item{fpath}{A string. The path to the directory where the plot will be saved}

\item{ylab}{A string. The label of the y-axis, describing what is represented.}

\item{xlab}{A string. The label of the x-axis.}

\item{plotpdf}{A logical value. If TRUE, a pdf file is created instead of 
plotting to the graphics device.}

\item{plotbatch}{A logical value. If TRUE, plots for all regulons are saved 
in the same file. If FALSE, each plot for each regulon is saved in a different file.}

\item{panelHeights}{A numeric vector of length 2 specifying the relative heights
of the panels (regulon activity plot, and covariate tracks)}

\item{width}{A numeric value. Represents the width of the plot.}

\item{height}{A numeric value. Represents the height of the plot.}

\item{dummyEncode}{A logical value. If TRUE, all categorical variables are
dummy encoded. If FALSE, categorical variables are represented as one track 
and a legend is added to the plot.}

\item{divs}{A numeric vector of division positions in the covariate tracks.}
}
\value{
A plot of regulon activity and covariate tracks.
}
\description{
This method plots regulon activity for a given regulon in all samples and 
adds covariate tracks to evaluate the regulon activity distribution. The
samples are order by regulon activity for that particular regulon.
}
\details{
Automatic dummy encoding is available for categorical variables.
}
\examples{
 # load survival data
 data(survival.data)
 # load TNI-object
 data(stni, package = "RTN")
 
 # create TNS object
 stns <- tni2tnsPreprocess(stni, survivalData = survival.data,
 keycovar = c('Grade','Age'), time = 1, event = 2)
 stns <- tnsGSEA2(stns)
 
 # plot only binary covariates
 tnsPlotCovariates(stns, "MYB", 
 attribs = c("ER+", "ER-", "PR+", "PR-", "LumA", "LumB", "Basal", 
 "Her2", "Normal"), divs = c(2, 4))
 
 # also dummy encode categorical variables (LN and Grade)
 tnsPlotCovariates(stns, "MYB", 
 attribs = c("ER+", "ER-", "PR+", "PR-", "LumA", "LumB", "Basal", 
 "Her2", "Normal", "LN", "Grade"), divs = c(2, 4, 9, 12))
 
 # don't dummy encode categorical variables
 tnsPlotCovariates(stns, "MYB", attribs = c("ER+", "ER-", "PR+", "PR-",
 "LumA", "LumB", "Basal", "Her2", "Normal", "Grade"), divs = c(2, 4, 9),
 dummyEncode = FALSE)
 
}
