% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\docType{methods}
\name{tni2tnsPreprocess,TNI-method}
\alias{tni2tnsPreprocess,TNI-method}
\alias{tni2tnsPreprocess}
\title{Preprocessing of TNS class objects}
\usage{
\S4method{tni2tnsPreprocess}{TNI}(
  tni,
  survivalData = NULL,
  regulatoryElements = NULL,
  time = 1,
  event = 2,
  endpoint = NULL,
  pAdjustMethod = "BH",
  keycovar = NULL,
  samples = NULL,
  excludeMid = FALSE,
  excludeAttribs = NULL
)
}
\arguments{
\item{tni}{A \linkS4class{TNI} class, already processed with the same samples
listed in the survival data.frame.}

\item{survivalData}{A named data.frame with samples in rows and survival data 
in the columns (this does not need to be provided if avaibale in the 'TNI' object).}

\item{regulatoryElements}{A character vector specifying which 
'TNI' regulatory elements should be evaluated.}

\item{time}{A numeric or character value corresponding to the column of the 
data.frame where the time of last observation is given.}

\item{event}{A numeric or character value, corresponding to the columm of 
the data.frame where the 'event' information is given.}

\item{endpoint}{A numeric value. It represents the cut-off point for the 
'time', if any.}

\item{pAdjustMethod}{A single character value specifying the p-value 
adjustment method to be used (see 'p.adjust' function for details).}

\item{keycovar}{A character vector of 'keycovars' listed in 'survivalData' columns.}

\item{samples}{An optional character vector listing samples to be analyzed.}

\item{excludeMid}{A logical value. If TRUE, inconclusive dES values is not
consired in the survival analysis.}

\item{excludeAttribs}{A character vector of attributes listed in the column 
names of the survivalData, indicating sample groups to be excluded from 
the survival analysis. All attributes should be binary encoded.
Available attributes can be checked by running 
colnames(tnsGet(tns, "survivalData"))}
}
\value{
A preprocessed \linkS4class{TNS} class
}
\description{
Creates TNS class onbjects for regulons an survival data.
}
\examples{
# load survival data
data(survival.data, package = "RTNsurvival")

# load TNI-object
data(stni, package = "RTN")

# create a new TNS object
stns <- tni2tnsPreprocess(stni, survivalData = survival.data, 
        keycovar = c('Grade','Age'), time = 1, event = 2)

}
\seealso{
\code{\link{tni.preprocess}} for similar 
preprocessing.
}
