% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmTCGA.R
\name{kmTCGA}
\alias{kmTCGA}
\title{Plot Kaplan-Meier Estimates of Survival Curves for Survival Data}
\usage{
kmTCGA(
  x,
  times = "times",
  status = "patient.vital_status",
  explanatory.names = "1",
  main = "Survival Curves",
  risk.table = TRUE,
  risk.table.y.text = FALSE,
  conf.int = TRUE,
  return.survfit = FALSE,
  pval = FALSE,
  ggtheme = theme_RTCGA(),
  ...
)
}
\arguments{
\item{x}{A \code{data.frame} containing survival information. See \link{survivalTCGA}.}

\item{times}{The name of time variable.}

\item{status}{The name of status variable.}

\item{explanatory.names}{Names of explanatory variables to use in survival curves plot.}

\item{main}{Title of the plot.}

\item{risk.table}{Whether to show risk tables.}

\item{risk.table.y.text}{Whether to show long strata names in legend of the risk table.}

\item{conf.int}{Whether to show confidence intervals.}

\item{return.survfit}{Should return survfit object additionaly to survival plot?}

\item{pval}{Whether to add p-value of the log-rank test to the plot?}

\item{ggtheme}{a \code{ggtheme} to be used (set to \code{NULL}, if using \pkg{ggthemr} package)}

\item{...}{Further arguments passed to \link[survminer]{ggsurvplot}.}
}
\description{
Plots Kaplan-Meier estimates of survival curves for survival data.
}
\section{Issues}{


If you have any problems, issues or think that something is missing or is not
clear please post an issue on 
\href{https://github.com/RTCGA/RTCGA/issues}{https://github.com/RTCGA/RTCGA/issues}.
}

\examples{

## Extracting Survival Data
library(RTCGA.clinical)
survivalTCGA(BRCA.clinical, OV.clinical, extract.cols = "admin.disease_code") -> BRCAOV.survInfo

## Kaplan-Meier Survival Curves
kmTCGA(BRCAOV.survInfo, explanatory.names = "admin.disease_code",  pval = TRUE)

kmTCGA(BRCAOV.survInfo, explanatory.names = "admin.disease_code", main = "",
       xlim = c(0,4000))
       
# first munge data, then extract survival info
library(dplyr)
BRCA.clinical \%>\%
    filter(patient.drugs.drug.therapy_types.therapy_type \%in\%
               c("chemotherapy", "hormone therapy")) \%>\%
    rename(therapy = patient.drugs.drug.therapy_types.therapy_type) \%>\%
    survivalTCGA(extract.cols = c("therapy"))  -> BRCA.survInfo.chemo
                 
# first extract survival info, then munge data                  
    survivalTCGA(BRCA.clinical, 
                 extract.cols = c("patient.drugs.drug.therapy_types.therapy_type"))  \%>\%
    filter(patient.drugs.drug.therapy_types.therapy_type \%in\%
               c("chemotherapy", "hormone therapy")) \%>\%
    rename(therapy = patient.drugs.drug.therapy_types.therapy_type) -> BRCA.survInfo.chemo


kmTCGA(BRCA.survInfo.chemo, explanatory.names = "therapy",
       xlim = c(0, 3000), conf.int = FALSE)

}
\seealso{
\pkg{RTCGA} website \href{http://rtcga.github.io/RTCGA/articles/Visualizations.html}{http://rtcga.github.io/RTCGA/articles/Visualizations.html}.

Other RTCGA: 
\code{\link{RTCGA-package}},
\code{\link{boxplotTCGA}()},
\code{\link{checkTCGA}()},
\code{\link{convertTCGA}()},
\code{\link{datasetsTCGA}},
\code{\link{downloadTCGA}()},
\code{\link{expressionsTCGA}()},
\code{\link{heatmapTCGA}()},
\code{\link{infoTCGA}()},
\code{\link{installTCGA}()},
\code{\link{mutationsTCGA}()},
\code{\link{pcaTCGA}()},
\code{\link{readTCGA}()},
\code{\link{survivalTCGA}()},
\code{\link{theme_RTCGA}()}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\concept{RTCGA}
