% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infoTCGA.R
\name{infoTCGA}
\alias{infoTCGA}
\title{Information About Cohorts from TCGA Project}
\usage{
infoTCGA()
}
\value{
A list with a tabular information from \href{https://gdac.broadinstitute.org/}{https://gdac.broadinstitute.org/}.
}
\description{
Function restores codes and counts for each cohort from TCGA project.
}
\section{Issues}{


If you have any problems, issues or think that something is missing or is not
clear please post an issue on 
\href{https://github.com/RTCGA/RTCGA/issues}{https://github.com/RTCGA/RTCGA/issues}.
}

\examples{

infoTCGA()
library(magrittr)
(cohorts <- infoTCGA() \%>\% 
rownames() \%>\% 
   sub('-counts', '', x=.))
   
# in knitr chunk -> results='asis'   
knitr::kable(infoTCGA())

}
\seealso{
\pkg{RTCGA} website \href{https://rtcga.github.io/RTCGA/articles/Data_Download.html}{https://rtcga.github.io/RTCGA/articles/Data_Download.html}.

Other RTCGA: 
\code{\link{RTCGA-package}},
\code{\link{boxplotTCGA}()},
\code{\link{checkTCGA}()},
\code{\link{convertTCGA}()},
\code{\link{datasetsTCGA}},
\code{\link{downloadTCGA}()},
\code{\link{expressionsTCGA}()},
\code{\link{heatmapTCGA}()},
\code{\link{installTCGA}()},
\code{\link{kmTCGA}()},
\code{\link{mutationsTCGA}()},
\code{\link{pcaTCGA}()},
\code{\link{readTCGA}()},
\code{\link{survivalTCGA}()},
\code{\link{theme_RTCGA}()}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\concept{RTCGA}
